#ifdef GL_ES
precision mediump float;

varying	vec3 lightVector, halfVector, lightVector2;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 lightVector, halfVector, lightVector2;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D normalTex;
uniform sampler2D colorTex;
uniform float brightness;
uniform float texStart;
uniform float texLength;

void main()
{
    float sample = max(mod(vTexCoord.t - texStart, texLength), mod(texLength - (vTexCoord.t - texStart), texLength)) + texStart;
    vec2 coord = vec2(vTexCoord.s, sample);
#ifdef GL_ES
	vec3 bump = (texture2D(normalTex, coord).xyz * 2.0 - 1.0);
	vec4 tColor = texture2D(colorTex, coord);
#else
    vec3 bump = (texture(normalTex, coord).xyz * 2.0 - 1.0);
    vec4 tColor = texture(colorTex, coord);
#endif

	float lambert = (max(0.0, dot(bump, normalize(lightVector))) + max(0.0, dot(bump, normalize(lightVector2)))) * brightness;
	
	/* red book p. 223 */
	vec3 diffuse = tColor.rgb * (lambert * 0.75);
	float specular = pow(max(0.0, dot(bump, normalize(halfVector))), 8.0) * tColor.a * 0.35;
	
	fragColor = vec4(diffuse + vec3(specular), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
